/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.furniture.block.AbstractChair;

public abstract class BaseBarStool
extends AbstractChair {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BaseBarStool(Block block) {
        super(block, 15);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public static BaseBarStool from(Block source) {
        return BehaviourHelper.from(source, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BaseBarStool
    implements BehaviourMetal {
        public Metal(Block block) {
            super(block);
        }
    }

    public static class Stone
    extends BaseBarStool
    implements BehaviourStone {
        public Stone(Block block) {
            super(block);
        }
    }

    public static class Wood
    extends BaseBarStool
    implements BehaviourWood {
        public Wood(Block block) {
            super(block);
        }
    }
}

